function [peak1s, peak2s, peak2_extrs, time_vec_s, EPSCs_trans, stim1_begs] = data_analyze_abf_WT_OK(filename, file_num, plot_on_off, show_plot_on_off)


%   filename = '17n23020.abf'

% filename = '2019_11_26_0075.abf';
num_sweeps = 1;

%  filename = '2019_11_25_0155.abf'
[trace_data, time_step_us, ~] = abfload(filename);

size_data = size(trace_data);
size_time = size_data(1);
time_step_ms = time_step_us*1e-3;

ISI = 10; %ms
ISI_ind = ISI/time_step_ms;

time_vec_s = (time_step_ms:time_step_ms:(time_step_ms*size_time))'*1e-3;

trace_current_nA = squeeze(trace_data(:,3,:)*1e-3);
diff_data = abs(diff(trace_current_nA,1));    
trace_cur_trans = zeros(size(trace_current_nA));
trace_cur_trans_0 = zeros(size(trace_current_nA));

peak1s = zeros(num_sweeps,1);
peak2s = zeros(num_sweeps(end),1);
peak2_extrs = zeros(num_sweeps(end),1);

EPSCs_trans = zeros(size(trace_current_nA));


    
    stim1_beg_0 = find(abs(trace_current_nA - trace_current_nA(1)) > 50 , 1, 'first') - 1;  %find(diff_data(:) > 5000, 1, 'first');  
    base_cur_0 = mean(trace_current_nA(1:(stim1_beg_0-10)));
    
    trace_cur_trans_0(:) = trace_current_nA - base_cur_0;
    
    trace_cur_signs = sign(trace_cur_trans(1:stim1_beg_0));
    stim1_beg = find(trace_cur_signs ~= sign(trace_cur_trans_0(stim1_beg_0)), 1, 'last') + 1;
    
    noise_size = max(abs(trace_cur_trans_0(1:(stim1_beg-1))));
%     stim1_beg = find(abs(trace_cur_trans_0(:)) > noise_size, 1, 'first');
    base_cur = mean(trace_current_nA(1:(stim1_beg-1)));
    trace_cur_trans(:) = trace_current_nA - base_cur;
    [~, stim_peak_0] = max(trace_cur_trans(stim1_beg:(stim1_beg + ISI_ind)));
    stim_peak_ind = stim_peak_0 + stim1_beg - 1;
    stim1_end = find(trace_cur_trans(stim_peak_ind:(stim_peak_ind + ISI_ind)) < noise_size, 1, 'first') + stim_peak_ind - 1;
    trace_cur_trans((stim1_beg):stim1_end) = NaN;
    stim2_ind = (stim1_beg+ISI_ind):(stim1_end+ISI_ind);
    trace_cur_trans(stim2_ind) = NaN;

    stim1_begs = stim1_beg;
    EPSCs_trans = trace_cur_trans;
    
    
    [peak1, peak1_ind] = nanmin(trace_cur_trans(1:stim2_ind(1)));
    peak1s = peak1;
    [valley, valley_ind_0] = nanmax(trace_cur_trans(peak1_ind:(peak1_ind+ISI_ind)));
    valley_ind = peak1_ind + valley_ind_0 - 1;
    [peak2_0, peak2_ind_0] = nanmin(trace_cur_trans(valley_ind:end));
    peak2_ind = valley_ind + peak2_ind_0 - 1;
    peak2 = peak2_0 - valley;
    peak2s = peak2;
    

    
    fit_start = find(trace_cur_trans(peak1_ind:valley_ind) > 0.9*peak1, 1, 'first') + peak1_ind -1;
    
    fit_ind = fit_start:(stim2_ind(1)-1);
    expo_fit = fit(time_vec_s(fit_ind), trace_cur_trans(fit_ind), 'exp1');
    peak2_extr = peak2_0 - expo_fit(time_vec_s(peak2_ind));
    peak2_extrs = peak2_extr;

    

    
    
    
    
    
    mwidth = 9;
    
    

    if plot_on_off == 1
        if show_plot_on_off == 0
            figure('visible', 'off')
        else
        	figure
        end
        hold on
        plot(time_vec_s(100:1000), trace_cur_trans(100:1000), 'k-')
        plot(time_vec_s((peak1_ind-mwidth):(peak1_ind+mwidth)), repmat(peak1,2*mwidth+1,1), 'r-', 'LineWidth', 2)
        plot(time_vec_s((peak2_ind-mwidth):(peak2_ind+mwidth)), repmat(peak2_0,2*mwidth+1,1), 'r-', 'LineWidth', 2)
        plot(time_vec_s(fit_ind(1):peak2_ind), expo_fit(time_vec_s(fit_ind(1):peak2_ind)), 'b-', 'LineWidth', 2)
        plot(time_vec_s((valley_ind-mwidth):(valley_ind+mwidth)), repmat(valley,2*mwidth+1,1), 'g-', 'LineWidth', 2)   
%         plot(time_vec_s([1 500]), [0 0], 'k', 'LineWidth', 2)
        plot([time_vec_s(peak2_ind) time_vec_s(peak2_ind)], [expo_fit(time_vec_s(peak2_ind)) peak2_0], '--', 'Color', [0.25 0.25 0.25])
        plot([time_vec_s(peak1_ind) time_vec_s(peak1_ind)], [0 peak1], '--', 'Color', [0.25 0.25 0.25])
        xlim([100 600]*1e-4)
        xlabel('Time [ms]')
        ylabel('Current [nA]')
        set(gca, 'TickDir', 'out', 'XColor', 'k', 'Ycolor', 'k', 'Linewidth', 1)
        saveas(gcf, ['./Exp_data/Exp_trace_plots/trace_' num2str(file_num) '.eps'], 'epsc')

    end
%     close all
